<?php
/* --------------------------------------------------------------
 AbstractBootableServiceProvider.php 2020-04-03
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

namespace Gambio\Core\Application\ServiceProviders\Abstraction;

use League\Container\ServiceProvider\ServiceProviderInterface;

/**
 * Class AbstractBootableServiceProvider
 * @package Gambio\Core\Application\ServiceProviders\Abstraction
 */
abstract class AbstractBootableServiceProvider extends AbstractServiceProvider implements BootableServiceProvider
{
    /**
     * @inheritDoc
     */
    public function toLeagueInterface(): ServiceProviderInterface
    {
        return new BootableLeagueServiceProvider($this);
    }
}